package test.andsmbclient;

import android.app.Activity;
import android.content.Intent;
import android.net.Uri;
import android.os.Bundle;
import android.util.Log;
import android.view.View;
import android.widget.Button;

public class MainActivity extends Activity 
{
	private static final String TAG = MainActivity.class.getName();
	private static final int UPLOAD_FILES_REQUEST = 0;
	private static final int DOWNLOAD_FILES_REQUEST = 1;
	private static final int UPLOAD_FOLDER_REQUEST = 2;
	private static final int DOWNLOAD_FOLDER_REQUEST = 3;
	private static final int DOWNLOAD_FILE_ALIAS_REQUEST = 4;
	private static final int BROWSE_REQUEST = 5;
	private static final int SEND_REQUEST = 6;
	
    public void onCreate(Bundle savedInstanceState) 
    {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.main);
        
        // Upload files sample
        Button uploadFilesButton = (Button) findViewById(R.id.button_upload_files_id);
        uploadFilesButton.setOnClickListener(new View.OnClickListener()
        {
			public void onClick(View v) 
			{
				Intent intent = new Intent();
				intent.setAction(Intent.ACTION_PICK);
				// SMB URL (Starts smb:// followed by hostname and port).
				Uri smbUri = Uri.parse("smb://192.168.20.128");
				intent.setDataAndType(smbUri, "vnd.android.cursor.dir/lysesoft.andsmb.uri");
				// Upload
				intent.putExtra("command_type", "upload");
				// SMB credentials (optional)
				intent.putExtra("smb_username", "guest");
				//intent.putExtra("smb_password", "yourpassword");
				//intent.putExtra("smb_domain", "YOURDOMAIN");
				// SMB settings (optional)
				//intent.putExtra("smb_encoding", "UTF-8");
				// Activity title
				intent.putExtra("progress_title", "Uploading files ...");
				intent.putExtra("local_file1", "/sdcard/subfolder1/file1.zip");
				intent.putExtra("local_file2", "/sdcard/subfolder2/file2.zip");
				// Optional initial remote folder (it must exist before upload)
				intent.putExtra("remote_folder", "/remotefolder/subfolder");
				//intent.putExtra("close_ui", "true");
				startActivityForResult(intent, UPLOAD_FILES_REQUEST);
			}
        });
                
        // Download files sample.
        Button downloadFilesButton = (Button) findViewById(R.id.button_download_files_id);
        downloadFilesButton.setOnClickListener(new View.OnClickListener()
        {
			public void onClick(View v) 
			{
				Intent intent = new Intent();
				intent.setAction(Intent.ACTION_PICK);
				// SMB URL (Starts smb:// followed by hostname and port).
				Uri smbUri = Uri.parse("smb://192.168.20.128");
				intent.setDataAndType(smbUri, "vnd.android.cursor.dir/lysesoft.andsmb.uri");
				// Download
				intent.putExtra("command_type", "download");
				// SMB credentials (optional)
				intent.putExtra("smb_username", "guest");
				//intent.putExtra("smb_password", "yourpassword");
				//intent.putExtra("smb_domain", "YOURDOMAIN");
				// SMB settings (optional)
				//intent.putExtra("smb_encoding", "UTF-8");
				// Activity title
				intent.putExtra("progress_title", "Downloading files ...");
				// Remote files to download.
				intent.putExtra("remote_file1", "/remotefolder/subfolder/file1.zip");
				intent.putExtra("remote_file2", "/remotefolder/subfolder/file2.zip");
				// Target local folder where files will be downloaded.
				intent.putExtra("local_folder", "/sdcard/localfolder");	
				intent.putExtra("close_ui", "true");	
				startActivityForResult(intent, DOWNLOAD_FILES_REQUEST);
			}
        });
        
        // Upload folder sample.
        Button uploadFolderButton = (Button) findViewById(R.id.button_upload_folder_id);
        uploadFolderButton.setOnClickListener(new View.OnClickListener()
        {
			public void onClick(View v) 
			{
				Intent intent = new Intent();
				intent.setAction(Intent.ACTION_PICK);
				// SMB URL (Starts smb:// followed by hostname and port).
				Uri smbUri = Uri.parse("smb://192.168.20.128");
				intent.setDataAndType(smbUri, "vnd.android.cursor.dir/lysesoft.andsmb.uri");
				// SMB credentials (optional)
				intent.putExtra("smb_username", "guest");
				//intent.putExtra("smb_password", "yourpassword");
				//intent.putExtra("smb_domain", "YOURDOMAIN");
				// SMB settings (optional)
				//intent.putExtra("smb_encoding", "UTF-8");
				// Upload
				intent.putExtra("command_type", "upload");
				// Activity title
				intent.putExtra("progress_title", "Uploading folder ...");
				intent.putExtra("local_file1", "/sdcard/localfolder");
				// Optional initial remote folder (it must exist before upload)
				intent.putExtra("remote_folder", "/remotefolder/uploadedfolder");
				startActivityForResult(intent, UPLOAD_FOLDER_REQUEST);
			}
        });      
        
        // Download full folder
        Button downloadFolderButton = (Button) findViewById(R.id.button_download_folder_id);
        downloadFolderButton.setOnClickListener(new View.OnClickListener()
        {
			public void onClick(View v) 
			{
				Intent intent = new Intent();
				intent.setAction(Intent.ACTION_PICK);
				// SMB URL (Starts smb:// followed by hostname and port).
				Uri smbUri = Uri.parse("smb://192.168.20.128");
				intent.setDataAndType(smbUri, "vnd.android.cursor.dir/lysesoft.andsmb.uri");
				// SMB credentials (optional)
				intent.putExtra("smb_username", "guest");
				//intent.putExtra("smb_password", "yourpassword");
				//intent.putExtra("smb_domain", "YOURDOMAIN");
				// SMB settings (optional)
				//intent.putExtra("smb_encoding", "UTF-8");	
				// Download
				intent.putExtra("command_type", "download");
				// Activity title
				intent.putExtra("progress_title", "Downloading folder ...");
				// Remote folder to download (must not end with /).
				intent.putExtra("remote_file1", "/remotefolder/uploadedfolder");
				intent.putExtra("local_folder", "/sdcard/downloadedfolder");			
				startActivityForResult(intent, DOWNLOAD_FOLDER_REQUEST);
			}
        }); 
        
        // Pass alias matching to SMB configuration in AndSMB.
        Button downloadFileAliasButton = (Button) findViewById(R.id.button_download_file_alias_id);
        downloadFileAliasButton.setOnClickListener(new View.OnClickListener()
        {
			public void onClick(View v) 
			{
				Intent intent = new Intent();
				intent.setAction(Intent.ACTION_PICK);
				Uri smbUri = Uri.parse("alias://myandsmbalias");
				intent.setDataAndType(smbUri, "vnd.android.cursor.dir/lysesoft.andsmb.uri");
				intent.putExtra("command_type", "download");
				intent.putExtra("remote_file1", "/remotefolder/subfolder/file1.zip");
				intent.putExtra("local_folder", "/sdcard/downloadedfolderalias");	
				startActivityForResult(intent, DOWNLOAD_FILE_ALIAS_REQUEST);
			}
        });    


        // Browse SMB server.
        Button explorerButton = (Button) findViewById(R.id.button_explorer_id);
        explorerButton.setOnClickListener(new View.OnClickListener()
        {
			public void onClick(View v)
			{
				Intent intent = new Intent();
				intent.setAction(Intent.ACTION_VIEW);
				Uri smbUri = Uri.parse("smb://192.168.20.128:445");
				intent.setData(smbUri);
				intent.putExtra("smb_username", "guest");
				//intent.putExtra("smb_password", "yourpassword");
				//intent.putExtra("smb_domain", "YOURDOMAIN");
				// Optional share and/or remote folder.
				//intent.putExtra("remote_folder", "/yourshare/subfolder");
				startActivityForResult(intent, BROWSE_REQUEST);
			}
        });      
        
        // Share (upload) from gallery.
        Button shareButton = (Button) findViewById(R.id.button_share_id);
        shareButton.setOnClickListener(new View.OnClickListener()
        {
			public void onClick(View v) 
			{
				Intent intent = new Intent();
				intent.setAction(Intent.ACTION_SEND);
				intent.setType("image/jpeg");
				intent.putExtra(Intent.EXTRA_STREAM, Uri.parse("content://media/external/images/media/103"));
				startActivityForResult(intent, SEND_REQUEST);
			}
        });   
    }


	protected void onActivityResult(int requestCode, int resultCode, Intent intent) 
	{
		Log.i(TAG, "Result: "+resultCode+ " from request: "+requestCode);
		if (intent != null)
		{
			String transferredBytesStr = intent.getStringExtra("TRANSFERSIZE");
			String transferTimeStr = intent.getStringExtra("TRANSFERTIME");
			Log.i(TAG, "Transfer status: " + intent.getStringExtra("TRANSFERSTATUS"));
			Log.i(TAG, "Transfer amount: " + intent.getStringExtra("TRANSFERAMOUNT") + " file(s)");
			Log.i(TAG, "Transfer size: " + transferredBytesStr + " bytes");
			Log.i(TAG, "Transfer time: " + transferTimeStr + " milliseconds");
			// Compute transfer rate.
			if ((transferredBytesStr != null) && (transferTimeStr != null))
			{
				try
				{
					long transferredBytes = Long.parseLong(transferredBytesStr);
					long transferTime = Long.parseLong(transferTimeStr);
					double transferRate = 0.0;
					if (transferTime > 0) transferRate = ((transferredBytes) * 1000.0) / (transferTime * 1024.0);
					Log.i(TAG, "Transfer rate: " + transferRate + " KB/s");
				} 
				catch (NumberFormatException e)
				{
					// Cannot parse string.
				}
			}
		}
	}
    
}